  
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:08:02 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_UTIL.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* canceling the lint warning: */
/*lint --e{718} */
/*lint --e{746} */
/*lint --e{826} */
/* disable Visual studio 2005 warning */
/*lint --e{553} */
/* disable warning for unknown define SST_DEBUG_MODE_ENABLED in case of rel mode */
#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#endif

/************* Include Files ***********************************/
#include "SST_TST.h"
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/

/*****************************************************************************
 * Function Name:                                                           
 *  ATP_LOG_TST_PRINT       
 * 
 * Inputs:
 *  DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *  const char format,... - the printf format.   
 *  
 * Outputs:
 *   None                                   
 *
 * Description:                                                                 
 * The following function Handel the printings logging of the testing suite . 
 *        This function should be called by using the ATP_LOG_TST_PLOT macro
 *
 ******************************************************************************/
#if ATP_LOG_TST_MAX_LEVEL_ENABLED

int SST_ATP_LOG_TST( DxUint8_t level , const char *format,... )
{
   DxError_t             TST_Status = DX_SUCCESS;
  /* LOCAL DECLERATIONS */
  va_list ap;
  FILE *TST_log_ptr = DX_NULL;

  /* FUNCTION LOGIC */
    if (TST_log_fname_ptr != DX_NULL)
    {
       TST_log_ptr = fopen(TST_log_fname_ptr,"a+");
       if (TST_Error != TESTPASS) 
       {
       printf("CANT OPEN LOG FILE \n");
           return TESTFAIL;
       }
    }
    else
  TST_log_ptr = stdout;
    /* if the printing level is enabled then print it */ 
    if( level < ATP_LOG_TST_MAX_LEVEL_ENABLED )
    {
        va_start(ap, format);
    vfprintf(TST_log_ptr,format,ap);
        va_end(ap);
    }  
    if (TST_log_fname_ptr != DX_NULL)
        fclose(TST_log_ptr);
  return TESTPASS;
   
}/* END OF ATP_LOG_TST */

#endif

/*****************************************************************************
 * Function Name:                                                           
 *  TST_CheckErrorReturn        
 * 
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation had succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t TST_CheckErrorReturn(DxError_t TST_ErrorRet, 
                                  char    TST_FuncName[TST_FUNC_STRING_LEN],
                                  char    TST_SubTestName[TST_FUNC_STRING_LEN],
                                  char    TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if ((TST_ErrorRet == SST_RC_OK)||(TST_ErrorRet == CRYS_OK))
        {
            ATP_LOG_TST_PRINT((SST_TST_MSG,"TST_message - "));
            ATP_LOG_TST_PRINT((SST_TST_MSG,"%s",TST_FuncName));
            ATP_LOG_TST_PRINT((SST_TST_MSG," pass \n"));                                       
            return TESTPASS;
        }
    else
        {
            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName));            
            ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
            ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - SST_Error returned 0x%x \n",TST_ErrorRet));   
            return TESTFAIL;
        }
}
/*****************************************************************************
 * Function Name:                                                           
 *  TST_CheckExpectedErrorReturn        
 * 
 * Inputs:
 *  DxUint32_t TST_ErrorRet - The return value of the checked function
 *  DxUint32_t TST_ExpectedError - The expected return value of the checked function
 *  char     TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function
 * comparing the received result Vs the expected result 
 * If the operation had succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t TST_CheckExpectedErrorReturn(DxError_t TST_ErrorRet, 
                                          DxError_t TST_ExpectedError, 
                                          char         TST_FuncName[TST_FUNC_STRING_LEN],
                                          char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                          char         TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    FILE        *Log_File_descriptor = DX_NULL;
    char     TST_File_Location[SST_TST_FILE_PATH_LENGTH];

 
    if (TST_ErrorRet != TST_ExpectedError)
    {
   
        ATP_LOG_TST_PRINT((SST_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName));           
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - Wrong Error returned!\n"));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - Error returned  --- %lX \n" ,TST_ErrorRet )); 
      
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - instead of Error --- %lX \n" ,TST_ExpectedError ));           
       
                
    #if SST_TST_PRINT_TO_LOG_FILE

    DX_VOS_StrNCopy(TST_File_Location,sizeof(SST_TST_RESULT_LOG),SST_TST_RESULT_LOG);

        if (( Log_File_descriptor = fopen( TST_File_Location ,"a+")) == DX_NULL)   
        {
            ATP_LOG_TST_PRINT((SST_TST_MSG,"Can't open Log_File_descriptor \n"));
        }
        else
        {   
            fprintf(Log_File_descriptor,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");       
            fprintf(Log_File_descriptor,"!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName);
            fprintf(Log_File_descriptor,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName);         
            fprintf(Log_File_descriptor,"!!!! TST_Error - %s failed\n",TST_FuncName);
            fprintf(Log_File_descriptor,"!!!! TST_Error - Wrong Error returned!\n");
            fprintf(Log_File_descriptor,"!!!! TST_Error - Error returned  --- %lX \n" ,TST_ErrorRet); 
            fprintf(Log_File_descriptor,"!!!! TST_Error - instead of Error --- %lX \n" ,TST_ExpectedError) ;
            fprintf(Log_File_descriptor,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");             
            fclose(Log_File_descriptor);
        }
    #endif 
        return TESTFAIL;      
    }
    else
    {
        ATP_LOG_TST_PRINT((SST_TST_MSG,"TST_massage - "));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"%s",TST_FuncName));
        ATP_LOG_TST_PRINT((SST_TST_MSG," Error returned correctly - Test pass \n"));                          
        return TESTPASS;        
    }   
}


/*****************************************************************************
 * Function Name:
 * SST_ATP_TST_ShowSSTVersion
 * Inputs:
 *  none
 *
 * Description:
 * This function prints the SST version and sub versions
 *
 ******************************************************************************/
void SST_ATP_TST_ShowSSTVersion(void)
{
  SSTVersion_t TST_SST_version;

  SST_VersionGet(&TST_SST_version);

    /*Printing the SST version and Engines */
    /*--------------------------------------*/
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n--------------[ SST VERSION ]-----------------------------------"));
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n SST VERSION  - %c%c%c-%c%d,%d,%d,%d",
                                         TST_SST_version.sst.componentName[0],
                                         TST_SST_version.sst.componentName[1],
                                         TST_SST_version.sst.componentName[2],
                                         TST_SST_version.sst.typeVer,
                                         TST_SST_version.sst.majorVer,
                                         TST_SST_version.sst.minorVer,
                                         TST_SST_version.sst.subVer,
                                         TST_SST_version.sst.internalVer));
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n-----------------------------------------------------------------"));
}

